<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BodegaController extends Controller
{
    public function index()
    {
        $bodegas = DB::table('bodegas')->orderBy('id', 'desc')->paginate(10);
        $total = DB::table('bodegas')->count();
        $por_estado = DB::table('bodegas')
            ->select('status', DB::raw('COUNT(*) as total'))
            ->groupBy('status')
            ->pluck('total', 'status');

        return view('bodegas.index', compact('bodegas', 'total', 'por_estado'));
    }

    public function store(Request $request)
    {
        DB::table('bodegas')->insert([
            'nombre' => $request->nombre,
            'ubicacion' => $request->ubicacion,
            'responsable' => $request->responsable,
            'descripcion' => $request->descripcion,
            'status' => $request->status,
            'created_at' => now(),
            'updated_at' => now()
        ]);

        return response()->json(['success' => true]);
    }

    public function update(Request $request, $id)
    {
        DB::table('bodegas')->where('id', $id)->update([
            'nombre' => $request->nombre,
            'ubicacion' => $request->ubicacion,
            'responsable' => $request->responsable,
            'descripcion' => $request->descripcion,
            'status' => $request->status,
            'updated_at' => now()
        ]);

        return response()->json(['success' => true]);
    }
}
