@extends('layouts.dashboard')

@section('title', 'Bodegas - J&D')

@section('content')
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Bodegas</h1>
    <p class="page-subtitle">Gestión completa de bodegas del sistema Comercializadora J&D</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Bodegas</p>
        <h2 class="stats-value">{{ $total }}</h2>
      </div>
    </div>
    @php
      $statuses = ['Activa'=>'active','Inactiva'=>'inactive'];
    @endphp
    @foreach($statuses as $estado => $class)
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card {{ $class }}">
          <p class="stats-title">{{ $estado }}</p>
          <h2 class="stats-value">{{ $por_estado[$estado] ?? 0 }}</h2>
        </div>
      </div>
    @endforeach
  </div>

  <!-- 🏬 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Bodegas</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newBodegaModal">
        <i class="fas fa-plus me-2"></i>Nueva Bodega
      </button>
    </div>

    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-6">
          <input type="text" id="filterName" class="form-control" placeholder="Buscar por nombre...">
        </div>
        <div class="col-md-6">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Activa</option>
            <option>Inactiva</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="bodegasTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Nombre</th>
            <th>Ubicación</th>
            <th>Responsable</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          @foreach($bodegas as $b)
          <tr>
            <td>{{ $b->id }}</td>
            <td>{{ $b->nombre }}</td>
            <td>{{ $b->ubicacion }}</td>
            <td>{{ $b->responsable }}</td>
            <td><span class="badge {{ $b->status=='Activa'?'badge-active':'badge-inactive' }}">{{ $b->status }}</span></td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal{{ $b->id }}"><i class="fas fa-edit"></i></button>
            </td>
          </tr>

          <!-- ✏️ Edit Modal -->
          <div class="modal fade" id="editModal{{ $b->id }}" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Bodega</h5>
                  <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editBodegaForm" data-id="{{ $b->id }}">
                    @csrf
                    @method('PUT')
                    <input type="text" name="nombre" class="form-control mb-2" value="{{ $b->nombre }}" required>
                    <input type="text" name="ubicacion" class="form-control mb-2" value="{{ $b->ubicacion }}">
                    <input type="text" name="responsable" class="form-control mb-2" value="{{ $b->responsable }}">
                    <textarea name="descripcion" class="form-control mb-2">{{ $b->descripcion }}</textarea>
                    <select name="status" class="form-select mb-2">
                      <option {{ $b->status=='Activa'?'selected':'' }}>Activa</option>
                      <option {{ $b->status=='Inactiva'?'selected':'' }}>Inactiva</option>
                    </select>
                    <button type="submit" class="btn btn-primary-custom w-100">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          @endforeach
        </tbody>
      </table>
    </div>
    <div class="pagination-container p-3">
      {{ $bodegas->links('pagination::bootstrap-5') }}
    </div>
  </div>
</div>

<!-- ➕ Nueva Bodega -->
<div class="modal fade" id="newBodegaModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nueva Bodega</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newBodegaForm">@csrf
          <input type="text" name="nombre" class="form-control mb-2" placeholder="Nombre" required>
          <input type="text" name="ubicacion" class="form-control mb-2" placeholder="Ubicación">
          <input type="text" name="responsable" class="form-control mb-2" placeholder="Responsable">
          <textarea name="descripcion" class="form-control mb-2" placeholder="Descripción"></textarea>
          <select name="status" class="form-select mb-3"><option>Activa</option><option>Inactiva</option></select>
          <button class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', ()=>{
  const csrf = document.querySelector('meta[name="csrf-token"]').content;
  const showAlert=(icon,title,text,reload=false)=>{
    Swal.fire({icon,title,text,confirmButtonColor:'#FF4E02'}).then(()=>{if(reload)location.reload();});
  };
  document.getElementById('newBodegaForm').addEventListener('submit',async e=>{
    e.preventDefault();
    const fd=new FormData(e.target);
    const res=await fetch('{{ route('bodegas.store') }}',{method:'POST',headers:{'X-CSRF-TOKEN':csrf},body:fd});
    const data=await res.json();
    data.success?showAlert('success','Guardado','Bodega agregada correctamente',true):showAlert('error','Error','No se pudo guardar');
  });
  document.querySelectorAll('.editBodegaForm').forEach(f=>{
    f.addEventListener('submit',async e=>{
      e.preventDefault();
      const id=f.dataset.id;
      const fd=new FormData(f);
      const res=await fetch(`/bodegas/${id}`,{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'X-HTTP-Method-Override':'PUT'},body:fd});
      const data=await res.json();
      data.success?showAlert('success','Actualizada','Cambios guardados',true):showAlert('error','Error','No se pudo actualizar');
    });
  });
});
</script>
@endsection
