@extends('layouts.dashboard')

@section('title', 'Clientes - J&D')

@section('content')
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Clientes</h1>
    <p class="page-subtitle">Gestión de clientes y contactos del sistema Comercializadora J&D</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Clientes</p>
        <h2 class="stats-value">{{ $total }}</h2>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card active">
        <p class="stats-title">Activos</p>
        <h2 class="stats-value">{{ $activos }}</h2>
      </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card inactive">
        <p class="stats-title">Inactivos</p>
        <h2 class="stats-value">{{ $inactivos }}</h2>
      </div>
    </div>
  </div>

  <!-- 🧾 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Clientes</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newClientModal">
        <i class="fas fa-plus me-2"></i>Nuevo Cliente
      </button>
    </div>

    <div class="table-responsive">
      <table id="clientsTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Cliente</th>
            <th>Contacto</th>
            <th>Correo</th>
            <th>Teléfono</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          @php $row = 1; @endphp
          @foreach($clients as $c)
          <tr>
            <td>{{ $row++ }}</td>
            <td>{{ $c->client }}</td>
            <td>{{ $c->contact_name }}</td>
            <td>{{ $c->contact_email ?? '—' }}</td>
            <td>{{ $c->contact_phone ?? '—' }}</td>
            <td>
              <span class="badge {{ $c->status == 'Activo' ? 'badge-active' : 'badge-inactive' }}">
                {{ $c->status }}
              </span>
            </td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editClientModal{{ $c->id }}">
                <i class="fas fa-edit"></i>
              </button>
            </td>
          </tr>

          <!-- ✏️ Edit Modal -->
          <div class="modal fade" id="editClientModal{{ $c->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Cliente - {{ $c->client }}</h5>
                  <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editClientForm" data-id="{{ $c->id }}">
                    @csrf
                    @method('PUT')
                    <input type="text" name="client" class="form-control mb-2" 
                           value="{{ $c->client }}" placeholder="Nombre del cliente" required>
                    <input type="text" name="contact_name" class="form-control mb-2" 
                           value="{{ $c->contact_name }}" placeholder="Nombre del contacto" required>
                    <input type="email" name="contact_email" class="form-control mb-2" 
                           value="{{ $c->contact_email }}" placeholder="Correo del contacto">
                    <input type="text" name="contact_phone" class="form-control mb-2" 
                           value="{{ $c->contact_phone }}" placeholder="Teléfono del contacto">
                    <select name="status" class="form-select mb-3">
                      <option {{ $c->status == 'Activo' ? 'selected' : '' }}>Activo</option>
                      <option {{ $c->status == 'Inactivo' ? 'selected' : '' }}>Inactivo</option>
                    </select>
                    <button type="submit" class="btn btn-primary-custom w-100">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          @endforeach
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      {{ $clients->links('pagination::bootstrap-5') }}
    </div>
  </div>
</div>

<!-- 🆕 New Client Modal -->
<div class="modal fade" id="newClientModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Cliente</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newClientForm">
          @csrf
          <input type="text" name="client" class="form-control mb-2" placeholder="Nombre del cliente" required>
          <input type="text" name="contact_name" class="form-control mb-2" placeholder="Nombre del contacto principal" required>
          <input type="email" name="contact_email" class="form-control mb-2" placeholder="Correo del contacto principal">
          <input type="text" name="contact_phone" class="form-control mb-2" placeholder="Teléfono del contacto principal">
          <select name="status" class="form-select mb-3">
            <option>Activo</option>
            <option>Inactivo</option>
          </select>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar Cliente</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const csrf = document.querySelector('meta[name="csrf-token"]').content;

  // 🆕 Crear nuevo cliente
  document.getElementById('newClientForm').addEventListener('submit', async e => {
    e.preventDefault();
    const res = await fetch('{{ route('clients.store') }}', {
      method: 'POST',
      headers: { 'X-CSRF-TOKEN': csrf, 'Accept': 'application/json' },
      body: new FormData(e.target)
    });
    const d = await res.json();
    if (d.success) {
      alert('Cliente agregado correctamente');
      location.reload();
    }
  });

  // ✏️ Editar cliente existente
  document.querySelectorAll('.editClientForm').forEach(f => {
    f.addEventListener('submit', async e => {
      e.preventDefault();
      const id = f.dataset.id;
      const data = new FormData(f);

      const res = await fetch(`/clients/${id}`, {
        method: 'POST',
        headers: {
          'X-CSRF-TOKEN': csrf,
          'X-HTTP-Method-Override': 'PUT',
          'Accept': 'application/json'
        },
        body: data
      });

      const d = await res.json();
      if (d.success) {
        alert('Cliente actualizado correctamente');
        location.reload();
      }
    });
  });
});
</script>
@endsection
