@extends('layouts.dashboard')

@section('title', 'Inventario - J&D')

@section('content')
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Inventario</h1>
    <p class="page-subtitle">Gestión completa de productos y existencias del sistema Comercializadora J&D</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Productos</p>
        <h2 class="stats-value">{{ $total }}</h2>
      </div>
    </div>

    @php
      $statuses = ['Disponible'=>'active','Agotado'=>'warning','Inactivo'=>'inactive'];
    @endphp
    @foreach($statuses as $estado => $class)
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card {{ $class }}">
          <p class="stats-title">{{ $estado }}</p>
          <h2 class="stats-value">{{ $por_estado[$estado] ?? 0 }}</h2>
        </div>
      </div>
    @endforeach
  </div>

  <!-- 🧾 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Productos</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newProductoModal">
        <i class="fas fa-plus me-2"></i>Nuevo Producto
      </button>
    </div>

    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterName" class="form-control" placeholder="Buscar por nombre...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterCategoria" class="form-control" placeholder="Buscar por categoría...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Disponible</option>
            <option>Agotado</option>
            <option>Inactivo</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="inventarioTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Foto</th>
            <th>Producto</th>
            <th>Categoría</th>
            <th>Unidad</th>
            <th>Stock</th>
            <th>Precio Venta</th>
            <th>Bodega</th>
            <th>Proveedor</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          @foreach($productos as $p)
          <tr>
            <td>{{ $p->id }}</td>
            <td>
              @if($p->foto)
                <img src="{{ asset('storage/'.$p->foto) }}" width="45" height="45" class="rounded object-fit-cover">
              @else
                <i class="fa-solid fa-box text-secondary fs-4"></i>
              @endif
            </td>
            <td>{{ $p->nombre }}</td>
            <td>{{ $p->categoria_nombre ?? '—' }}</td>
            <td>{{ $p->unidad_nombre ?? $p->unidad_simbolo ?? '—' }}</td>
            <td><strong>{{ $p->stock_actual }}</strong></td>
            <td>Q{{ number_format($p->precio_venta,2) }}</td>
            <td>{{ $p->bodega_nombre ?? '—' }}</td>
            <td>{{ $p->vendor_nombre ?? '—' }}</td>
            <td>
              <span class="badge 
                @switch($p->status)
                  @case('Disponible') badge-active @break
                  @case('Agotado') badge-warning @break
                  @default badge-inactive
                @endswitch">
                {{ $p->status }}
              </span>
            </td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#viewModal{{ $p->id }}"><i class="fas fa-eye"></i></button>
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal{{ $p->id }}"><i class="fas fa-edit"></i></button>
            </td>
          </tr>

          <!-- 👁️ View Modal -->
          <div class="modal fade" id="viewModal{{ $p->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Detalles del Producto</h5>
                  <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <div class="row">
                    <div class="col-md-4 text-center">
                      @if($p->foto)
                        <img src="{{ asset('storage/'.$p->foto) }}" width="150" class="rounded mb-3 shadow-sm">
                      @else
                        <i class="fa-solid fa-box fa-5x text-secondary mb-3"></i>
                      @endif
                    </div>
                    <div class="col-md-8">
                      <p><strong>Nombre:</strong> {{ $p->nombre }}</p>
                      <p><strong>Categoría:</strong> {{ $p->categoria_nombre ?? '—' }}</p>
                      <p><strong>Unidad:</strong> {{ $p->unidad_nombre ?? $p->unidad_simbolo ?? '—' }}</p>
                      <p><strong>Precio Compra:</strong> Q{{ number_format($p->precio_compra,2) }}</p>
                      <p><strong>Precio Venta:</strong> Q{{ number_format($p->precio_venta,2) }}</p>
                      <p><strong>Stock Actual:</strong> {{ $p->stock_actual }}</p>
                      <p><strong>Bodega:</strong> {{ $p->bodega_nombre ?? '—' }}</p>
                      <p><strong>Proveedor:</strong> {{ $p->vendor_nombre ?? '—' }}</p>
                      <p><strong>Estado:</strong> {{ $p->status }}</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- ✏️ Edit Modal -->
          <div class="modal fade" id="editModal{{ $p->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Producto</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editProductoForm" data-id="{{ $p->id }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                      <div class="col-md-6 mb-2"><input type="text" name="nombre" class="form-control" value="{{ $p->nombre }}" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="codigo" class="form-control" value="{{ $p->codigo }}" placeholder="Código"></div>

                      <div class="col-md-6 mb-2">
                        <label class="form-label">Categoría</label>
                        <select name="categoria_id" class="form-select" required>
                          <option value="">Seleccionar categoría</option>
                          @foreach($categorias as $cat)
                            <option value="{{ $cat->id }}" {{ $p->categoria_id == $cat->id ? 'selected' : '' }}>{{ $cat->nombre }}</option>
                          @endforeach
                        </select>
                      </div>

                      <div class="col-md-6 mb-2">
                        <label class="form-label">Unidad de Medida</label>
                        <select name="unidad_medida_id" class="form-select" required>
                          <option value="">Seleccionar unidad</option>
                          @foreach($unidades as $u)
                            <option value="{{ $u->id }}" {{ $p->unidad_medida_id == $u->id ? 'selected' : '' }}>{{ $u->nombre }} ({{ $u->simbolo }})</option>
                          @endforeach
                        </select>
                      </div>

                      <div class="col-md-12 mb-2">
                        <label class="form-label">Bodega</label>
                        <select name="bodega_id" class="form-select">
                          <option value="">Seleccionar bodega</option>
                          @foreach($bodegas as $b)
                            <option value="{{ $b->id }}" {{ $p->bodega_id == $b->id ? 'selected' : '' }}>{{ $b->nombre }}</option>
                          @endforeach
                        </select>
                      </div>

                      <div class="col-md-12 mb-2">
                        <label class="form-label">Proveedor</label>
                        <select name="vendor_id" class="form-select">
                          <option value="">Seleccionar proveedor</option>
                          @foreach($vendors as $v)
                            <option value="{{ $v->id }}" {{ $p->vendor_id == $v->id ? 'selected' : '' }}>{{ $v->nombre }}</option>
                          @endforeach
                        </select>
                      </div>

                      <div class="col-md-6 mb-2"><input type="number" name="precio_compra" step="0.01" class="form-control" value="{{ $p->precio_compra }}" placeholder="Precio Compra"></div>
                      <div class="col-md-6 mb-2"><input type="number" name="precio_venta" step="0.01" class="form-control" value="{{ $p->precio_venta }}" placeholder="Precio Venta"></div>
                      <div class="col-md-6 mb-2"><input type="number" name="stock_actual" step="0.01" class="form-control" value="{{ $p->stock_actual }}" placeholder="Stock Actual"></div>
                      <div class="col-md-6 mb-2"><input type="number" name="stock_minimo" step="0.01" class="form-control" value="{{ $p->stock_minimo }}" placeholder="Stock Mínimo"></div>

                      <div class="col-md-6 mb-2">
                        <label>Foto del Producto</label>
                        <input type="file" name="foto" class="form-control">
                        @if($p->foto)
                          <a href="{{ asset('storage/'.$p->foto) }}" target="_blank" class="small d-block mt-1 text-primary">📸 Ver actual</a>
                        @endif
                      </div>

                      <div class="col-md-6 mb-2">
                        <select name="status" class="form-select">
                          <option {{ $p->status=='Disponible'?'selected':'' }}>Disponible</option>
                          <option {{ $p->status=='Agotado'?'selected':'' }}>Agotado</option>
                          <option {{ $p->status=='Inactivo'?'selected':'' }}>Inactivo</option>
                        </select>
                      </div>
                    </div>
                    <button type="submit" class="btn btn-primary-custom w-100 mt-3">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          @endforeach
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      {{ $productos->links('pagination::bootstrap-5') }}
    </div>
  </div>
</div>

<!-- ➕ Nuevo Producto -->
<div class="modal fade" id="newProductoModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Producto</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newProductoForm" enctype="multipart/form-data">@csrf
          <div class="row">
            <div class="col-md-6 mb-2"><input type="text" name="nombre" class="form-control" placeholder="Nombre del producto" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="codigo" class="form-control" placeholder="Código interno"></div>

            <div class="col-md-6 mb-2">
              <label class="form-label">Categoría</label>
              <select name="categoria_id" class="form-select" required>
                <option value="">Seleccionar categoría</option>
                @foreach($categorias as $cat)
                  <option value="{{ $cat->id }}">{{ $cat->nombre }}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-6 mb-2">
              <label class="form-label">Unidad de Medida</label>
              <select name="unidad_medida_id" class="form-select" required>
                <option value="">Seleccionar unidad</option>
                @foreach($unidades as $u)
                  <option value="{{ $u->id }}">{{ $u->nombre }} ({{ $u->simbolo }})</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-12 mb-2">
              <label class="form-label">Bodega</label>
              <select name="bodega_id" class="form-select">
                <option value="">Seleccionar bodega</option>
                @foreach($bodegas as $b)
                  <option value="{{ $b->id }}">{{ $b->nombre }}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-12 mb-2">
              <label class="form-label">Proveedor</label>
              <select name="vendor_id" class="form-select">
                <option value="">Seleccionar proveedor</option>
                @foreach($vendors as $v)
                  <option value="{{ $v->id }}">{{ $v->nombre }}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-6 mb-2"><input type="number" step="0.01" name="precio_compra" class="form-control" placeholder="Precio de compra"></div>
            <div class="col-md-6 mb-2"><input type="number" step="0.01" name="precio_venta" class="form-control" placeholder="Precio de venta"></div>
            <div class="col-md-6 mb-2"><input type="number" step="0.01" name="stock_actual" class="form-control" placeholder="Stock actual"></div>
            <div class="col-md-6 mb-2"><input type="number" step="0.01" name="stock_minimo" class="form-control" placeholder="Stock mínimo"></div>

            <div class="col-md-12 mb-3">
              <label>Foto del Producto</label>
              <input type="file" name="foto" class="form-control">
            </div>

            <div class="col-md-12 mb-3">
              <select name="status" class="form-select" required>
                <option>Disponible</option>
                <option>Agotado</option>
                <option>Inactivo</option>
              </select>
            </div>
          </div>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded',()=>{
  const csrf=document.querySelector('meta[name="csrf-token"]').content;
  const showAlert=(icon,title,text,reload=false)=>{
    Swal.fire({icon,title,text,confirmButtonColor:'#FF4E02'}).then(()=>{if(reload)location.reload();});
  };

  // ➕ Nuevo Producto
  const newForm=document.getElementById('newProductoForm');
  if(newForm){
    newForm.addEventListener('submit',async e=>{
      e.preventDefault();
      const fd=new FormData(newForm);
      const res=await fetch('{{ route('inventario.store') }}',{method:'POST',headers:{'X-CSRF-TOKEN':csrf},body:fd});
      const data=await res.json();
      data.success?showAlert('success','Producto agregado','El nuevo producto fue guardado correctamente.',true):showAlert('error','Error','No se pudo guardar el producto.');
    });
  }

  // ✏️ Editar Producto
  document.querySelectorAll('.editProductoForm').forEach(form=>{
    form.addEventListener('submit',async e=>{
      e.preventDefault();
      const id=form.dataset.id;
      const fd=new FormData(form);
      const res=await fetch(`/inventario/${id}`,{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'X-HTTP-Method-Override':'PUT'},body:fd});
      const data=await res.json();
      data.success?showAlert('success','Producto actualizado','Los cambios se guardaron correctamente.',true):showAlert('error','Error','No se pudo actualizar el producto.');
    });
  });

  // 🔍 Filtros
  const fName=document.getElementById('filterName');
  const fCat=document.getElementById('filterCategoria');
  const fStatus=document.getElementById('filterStatus');
  const rows=document.querySelectorAll('#inventarioTable tbody tr');

  function filter(){
    const n=fName.value.toLowerCase();
    const c=fCat.value.toLowerCase();
    const s=fStatus.value;
    rows.forEach(r=>{
      const name=r.cells[2].innerText.toLowerCase();
      const cat=r.cells[3].innerText.toLowerCase();
      const st=r.cells[9].innerText.trim();
      const show=(!n||name.includes(n))&&(!c||cat.includes(c))&&(!s||st===s);
      r.style.display=show?'':'none';
    });
  }
  [fName,fCat,fStatus].forEach(el=>{el.addEventListener('input',filter);el.addEventListener('change',filter);});
});
</script>
@endsection
