<!DOCTYPE html>
<html lang="es">
@include('includes.dashboard-styles')

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Panel - Comercializadora J&D')</title>

    <!-- âœ… Favicon -->
    <link rel="icon" sizes="32x32" href="{{ asset('public/logojd.png') }}">
    <link rel="apple-touch-icon" href="{{ asset('public/logojd.png') }}">
<meta name="mobile-web-app-capable" content="yes">

    <!-- âœ… Browser / Status Bar Color -->
    <meta name="theme-color" content="#1A3A5F" media="(prefers-color-scheme: light)">
    <meta name="theme-color" content="#1A3A5F" media="(prefers-color-scheme: dark)">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="msapplication-TileColor" content="#1A3A5F">
    <meta name="msapplication-navbutton-color" content="#1A3A5F">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <style>
        :root {
  --primary: #071F3C;        /* Azul ahora es el principal */
  --secondary: #FF4E02;      /* Rojo ahora es el secundario */
  --secondary-dark: #E55A2B; /* Tonalidad oscura del rojo */

  --grayish: #6B7280;
  --light-gray: #F3F4F6;
  --success: #10B981;
  --warning: #F59E0B;
  --danger: #EF4444;
  --info: #3B82F6;

  --sidebar-width: 250px;
}


        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #F5F6F8;
            margin: 0;
            padding: 0;
            display: flex;
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* === Sidebar === */
        .sidebar {
            width: var(--sidebar-width);
            background-color: var(--darkblue);
            color: white;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            transition: transform 0.3s ease;
            z-index: 1000;
        }

        .sidebar.hidden {
            transform: translateX(-100%);
        }

        .sidebar .logo {
            text-align: center;
            padding: 20px 0;
            background-color: var(--primary);
        }

        .sidebar .logo img {
            width: 140px;
            filter: brightness(0) invert(1);
        }

        .nav {
            flex: 1;
            padding: 20px;
        }

        .nav a {
            display: block;
            padding: 12px 16px;
            margin-bottom: 10px;
            border-radius: 6px;
            color: white;
            text-decoration: none;
            transition: background 0.3s;
            font-size: 15px;
        }

        .nav a:hover,
        .nav a.active {
            background-color: rgba(255, 255, 255, 0.15);
        }

        .bottom {
            padding: 20px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .bottom a {
            display: block;
            color: #87AF9B;
            text-decoration: none;
            padding: 10px 0;
            transition: color 0.3s;
        }

        .bottom a:hover {
            color: white;
        }

        /* === Main Content === */
        .main-content {
            flex: 1;
            margin-left: var(--sidebar-width);
            padding: 30px 40px;
            transition: margin-left 0.3s ease;
            width: 100%;
        }

        .sidebar.hidden~.main-content {
            margin-left: 0;
        }

        .main-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 25px;
        }

        .hamburger {
            display: none;
            font-size: 22px;
            color: var(--darkblue);
            background: none;
            border: none;
            cursor: pointer;
        }

        /* === Responsive === */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .hamburger {
                display: inline-block;
            }

            .main-content {
                margin-left: 0;
                padding: 20px;
            }
        }

        /* === Spinner Loader === */
        .loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.7);
            z-index: 2000;
            display: flex;
            align-items: center;
            justify-content: center;
            display: none;
        }

        .spinner {
            width: 60px;
            height: 60px;
            border: 6px solid #f3f3f3;
            border-top: 6px solid var(--primary);
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }
    </style>
</head>

<body>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <div>
        <div class="logo">
            <img src="{{ asset('public/logojds.png') }}" alt="JD Logo">
        </div>
        <div class="nav">
            <a href="{{ route('dashboard') }}" 
               class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
               <i class="fa-solid fa-gauge-high me-2"></i> Dashboard
            </a>

            <a href="{{ route('cargas.index') }}" 
               class="nav-link {{ request()->routeIs('cargas.*') ? 'active' : '' }}">
               <i class="fa-solid fa-box me-2"></i> Despachos
            </a>

            <!-- 📦 Inventario -->
            <a href="{{ route('inventario.index') }}" 
               class="nav-link {{ request()->routeIs('inventario.*') ? 'active' : '' }}">
               <i class="fa-solid fa-cubes me-2"></i> Inventario
            </a>

            <!-- 🏢 Bodegas -->
            <a href="{{ route('bodegas.index') }}" 
               class="nav-link {{ request()->routeIs('bodegas.*') ? 'active' : '' }}">
               <i class="fa-solid fa-warehouse me-2"></i> Bodegas
            </a>

            <a href="{{ route('camiones.index') }}" 
               class="nav-link {{ request()->routeIs('camiones.*') ? 'active' : '' }}">
               <i class="fa-solid fa-truck me-2"></i> Camiones
            </a>

            <a href="{{ route('conductores.index') }}" 
               class="nav-link {{ request()->routeIs('conductores.*') ? 'active' : '' }}">
               <i class="fa-solid fa-id-card me-2"></i> Conductores
            </a>

            <!-- 👥 Clientes -->
            <a href="{{ route('clients.index') }}" 
               class="nav-link {{ request()->routeIs('clients.*') ? 'active' : '' }}">
               <i class="fa-solid fa-building-user me-2"></i> Clientes
            </a>
            
            <a href="{{ route('proveedores.index') }}" 
   class="nav-link {{ request()->routeIs('proveedores.*') ? 'active' : '' }}">
   <i class="fa-solid fa-truck-field me-2"></i> Proveedores
</a>


            <a href="{{ route('usuarios.index') }}" 
               class="nav-link {{ request()->routeIs('usuarios.*') ? 'active' : '' }}">
               <i class="fa-solid fa-users me-2"></i> Usuarios
            </a>
        </div>
    </div>

    <div class="bottom">
        <a href="{{ route('usuarios.profile') }}" 
           class="nav-link {{ request()->routeIs('usuarios.profile') ? 'active' : '' }}">
           <i class="fa-solid fa-user me-2"></i> Perfil
        </a>
        <a href="{{ route('logout') }}" class="nav-link">
            <i class="fa-solid fa-right-from-bracket me-2"></i> Cerrar Sesión
        </a>
    </div>
</div>



    <!-- Main -->
    <div class="main-content">
        <div class="main-header">
            <button class="hamburger" id="hamburger"><i class="fa-solid fa-bars"></i></button>
        </div>
        @yield('content')
    </div>

    <!-- ðŸ”¸ Orange Spinner -->
    <div class="loader" id="loader">
        <div class="spinner"></div>
    </div>

    <script>
        const sidebar = document.getElementById('sidebar');
        const hamburger = document.getElementById('hamburger');
        const loader = document.getElementById('loader');

        // âœ… Sidebar toggle (mobile)
        hamburger.addEventListener('click', () => sidebar.classList.toggle('active'));

        // âœ… Close sidebar when clicking outside
        document.addEventListener('click', (e) => {
            const isClickInsideSidebar = sidebar.contains(e.target);
            const isClickOnHamburger = hamburger.contains(e.target);
            if (sidebar.classList.contains('active') && !isClickInsideSidebar && !isClickOnHamburger) {
                sidebar.classList.remove('active');
            }
        });

        // âœ… Show spinner for all navigation links (top + bottom)
        document.querySelectorAll('.nav-link').forEach(link => {
            link.addEventListener('click', e => {
                e.preventDefault();
                const href = e.currentTarget.getAttribute('href');
                loader.style.display = 'flex';
                setTimeout(() => {
                    window.location.href = href;
                }, 400);
            });
        });

        // âœ… Hide spinner after page load
        window.addEventListener('load', () => {
            loader.style.display = 'none';
        });
    </script>
    
    
<!-- ✅ Core JS Libraries -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


<style>
  .select2-container { z-index: 2000 !important; }
</style>


<!-- SweetAlert2 (global alerts) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



</body>
</html>
