

<?php $__env->startSection('title', 'Proveedores - J&D'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Proveedores</h1>
    <p class="page-subtitle">Gestión de proveedores y distribuidores del sistema Comercializadora J&D</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Proveedores</p>
        <h2 class="stats-value"><?php echo e($total); ?></h2>
      </div>
    </div>
  </div>

  <!-- 🧾 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Proveedores</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newProveedorModal">
        <i class="fas fa-plus me-2"></i>Nuevo Proveedor
      </button>
    </div>

    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Nombre</th>
            <th>Descripción</th>
            <th>Ubicación</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $proveedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($v->id); ?></td>
            <td><?php echo e($v->nombre); ?></td>
            <td><?php echo e($v->descripcion ?? '—'); ?></td>
            <td><?php echo e($v->ubicacion ?? '—'); ?></td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($v->id); ?>"><i class="fas fa-edit"></i></button>
              <button class="btn btn-sm btn-outline-danger deleteProveedor" data-id="<?php echo e($v->id); ?>"><i class="fas fa-trash"></i></button>
            </td>
          </tr>

          <!-- ✏️ Edit Modal -->
          <div class="modal fade" id="editModal<?php echo e($v->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Proveedor</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editProveedorForm" data-id="<?php echo e($v->id); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="mb-3">
                      <label>Nombre</label>
                      <input type="text" name="nombre" class="form-control" value="<?php echo e($v->nombre); ?>" required>
                    </div>
                    <div class="mb-3">
                      <label>Descripción</label>
                      <textarea name="descripcion" class="form-control"><?php echo e($v->descripcion); ?></textarea>
                    </div>
                    <div class="mb-3">
                      <label>Ubicación</label>
                      <input type="text" name="ubicacion" class="form-control" value="<?php echo e($v->ubicacion); ?>">
                    </div>
                    <button type="submit" class="btn btn-primary-custom w-100">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      <?php echo e($proveedores->links('pagination::bootstrap-5')); ?>

    </div>
  </div>
</div>

<!-- ➕ Nuevo Proveedor -->
<div class="modal fade" id="newProveedorModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Proveedor</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newProveedorForm"><?php echo csrf_field(); ?>
          <div class="mb-3">
            <label>Nombre</label>
            <input type="text" name="nombre" class="form-control" required>
          </div>
          <div class="mb-3">
            <label>Descripción</label>
            <textarea name="descripcion" class="form-control"></textarea>
          </div>
          <div class="mb-3">
            <label>Ubicación</label>
            <input type="text" name="ubicacion" class="form-control">
          </div>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded',()=>{
  const csrf=document.querySelector('meta[name="csrf-token"]').content;
  const showAlert=(icon,title,text,reload=false)=>{
    Swal.fire({icon,title,text,confirmButtonColor:'#FF4E02'}).then(()=>{if(reload)location.reload();});
  };

  // ➕ Nuevo Proveedor
  document.getElementById('newProveedorForm')?.addEventListener('submit',async e=>{
    e.preventDefault();
    const fd=new FormData(e.target);
    const res=await fetch('<?php echo e(route('proveedores.store')); ?>',{method:'POST',headers:{'X-CSRF-TOKEN':csrf},body:fd});
    const data=await res.json();
    data.success?showAlert('success','Proveedor agregado','El proveedor fue registrado correctamente.',true):showAlert('error','Error','No se pudo agregar el proveedor.');
  });

  // ✏️ Editar Proveedor
  document.querySelectorAll('.editProveedorForm').forEach(form=>{
    form.addEventListener('submit',async e=>{
      e.preventDefault();
      const id=form.dataset.id;
      const fd=new FormData(form);
      const res=await fetch(`/proveedores/${id}`,{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'X-HTTP-Method-Override':'PUT'},body:fd});
      const data=await res.json();
      data.success?showAlert('success','Proveedor actualizado','Los cambios fueron guardados correctamente.',true):showAlert('error','Error','No se pudo actualizar el proveedor.');
    });
  });

  // 🗑️ Eliminar Proveedor
  document.querySelectorAll('.deleteProveedor').forEach(btn=>{
    btn.addEventListener('click',async()=>{
      const id=btn.dataset.id;
      Swal.fire({
        icon:'warning',title:'¿Eliminar proveedor?',text:'Esta acción no se puede deshacer.',
        showCancelButton:true,confirmButtonText:'Sí, eliminar',cancelButtonText:'Cancelar',
        confirmButtonColor:'#d33',cancelButtonColor:'#6c757d'
      }).then(async result=>{
        if(result.isConfirmed){
          const res=await fetch(`/proveedores/${id}`,{method:'DELETE',headers:{'X-CSRF-TOKEN':csrf}});
          const data=await res.json();
          data.success?showAlert('success','Eliminado','El proveedor fue eliminado correctamente.',true):showAlert('error','Error','No se pudo eliminar el proveedor.');
        }
      });
    });
  });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/comercializadora/public_html/app.jdcomercializadora.com/resources/views/proveedores/index.blade.php ENDPATH**/ ?>