

<?php $__env->startSection('title', 'Tractores - Trainsa'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Tractores</h1>
    <p class="page-subtitle">Gestion de tractores, remolques y dollys asignados.</p>
  </div>

  <!-- ðŸ“Š Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Tractores</p>
        <h2 class="stats-value"><?php echo e($total); ?></h2>
      </div>
    </div>

    <?php
      $statuses = [
        'Cargado' => 'active',
        'Descargado' => 'inactive',
        'Cargando' => 'warning',
        'Descargando' => 'warning',
        'En Transito' => 'info',
        'En puerto' => 'info',
        'En Taller' => 'danger',
        'Sin Venta' => 'secondary',
        'Sin Operador' => 'secondary',
        'Activo' => 'success',
        'Inactivo' => 'dark'
      ];
    ?>

    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado => $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card <?php echo e($class); ?>">
          <p class="stats-title"><?php echo e($estado); ?></p>
          <h2 class="stats-value"><?php echo e($por_estado[$estado] ?? 0); ?></h2>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>

  <!-- ðŸš› Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Tractores</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newTractorModal">
        <i class="fas fa-plus me-2"></i>Nuevo Tractor
      </button>
    </div>
    
    
<!-- Modal Nuevo Tractor -->
<div class="modal fade" id="newTractorModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
          <div class="modal-header bg-dark text-white">
              <h5 class="modal-title">Nuevo Tractor</h5>
              <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body">
              <form id="newTractorForm">
                  <?php echo csrf_field(); ?>
                  <input type="text" name="brand" class="form-control mb-2" placeholder="Marca" required>
                  <input type="text" name="make" class="form-control mb-2" placeholder="Modelo" required>
                  <input type="text" name="plate" class="form-control mb-2" placeholder="Placa" required>
                  <select name="status" class="form-select mb-2">
                      <option>Cargado</option>
                      <option>Descargado</option>
                      <option>Cargando</option>
                  </select>
                  <select name="conductor_id" class="form-select mb-3">
                      <option value="">Ninguno</option>
                      <?php $__currentLoopData = $conductores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($c->id); ?>"><?php echo e($c->first_name); ?> <?php echo e($c->last_name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                  <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
              </form>
          </div>
      </div>
  </div>
</div>


    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterBrand" class="form-control" placeholder="Buscar por marca...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterPlate" class="form-control" placeholder="Buscar por placa...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Cargado</option>
            <option>Descargado</option>
            <option>Cargando</option>
            <option>En Transito</option>
            <option>En Taller</option>
          </select>
        </div>
      </div>
    </div>

 <div class="table-responsive">
  <table id="tractoresTable" class="table table-hover align-middle mb-0">
    <thead class="table-dark">
      <tr>
        
        <th>Unidad</th>
        <th>Marca</th>
        <th>Modelo</th>
        <th>Placa</th>
        <th>Serie</th>
        <th>Estado</th>
        <th>Conductor</th>
        <th>Remolques</th>
        <th>Dolly</th>
        <th class="text-center">Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php $__currentLoopData = $tractores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <tr>
        
        <td><strong><?php echo e($t->unidad); ?></strong></td>
        <td><?php echo e($t->brand); ?></td>
        <td><?php echo e($t->make); ?></td>
        <td><?php echo e($t->plate); ?></td>
        <td><?php echo e($t->serie); ?></td>
        <td>
          <span class="badge 
            <?php switch($t->status):
              case ('Cargado'): ?> badge-active <?php break; ?>
              <?php case ('Descargado'): ?> badge-inactive <?php break; ?>
              <?php case ('Cargando'): ?> badge-warning <?php break; ?>
              <?php case ('Descargando'): ?> badge-warning <?php break; ?>
              <?php case ('En Transito'): ?> badge-info <?php break; ?>
              <?php case ('En Taller'): ?> badge-danger <?php break; ?>
              <?php case ('Sin Venta'): ?> badge-secondary <?php break; ?>
              <?php case ('Sin Operador'): ?> badge-secondary <?php break; ?>
              <?php case ('Activo'): ?> badge-active <?php break; ?>
              <?php case ('Inactivo'): ?> badge-inactive <?php break; ?>
              <?php default: ?> badge-inactive
            <?php endswitch; ?>">
            <?php echo e($t->status); ?>

          </span>
        </td>
        <td><?php echo e($t->conductor_name ?? 'Ninguno'); ?></td>
        <td>
          <?php
            $remolquesAsignados = DB::table('remolques')->where('tractor_id', $t->id)->pluck('unidad')->toArray();
          ?>
          <?php if(count($remolquesAsignados)): ?>
            <?php echo e(implode(', ', $remolquesAsignados)); ?>

          <?php else: ?>
            <span class="text-muted">Ninguno</span>
          <?php endif; ?>
        </td>
        <td>
          <?php
            $dollyAsignado = DB::table('dollys')->where('tractor_id', $t->id)->value('unidad');
          ?>
          <?php echo e($dollyAsignado ?? 'Ninguno'); ?>

        </td>
        <td class="text-center">
          <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($t->id); ?>">
            <i class="fas fa-edit"></i>
          </button>
          <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#assignModal<?php echo e($t->id); ?>">
            <i class="fas fa-link"></i>
          </button>
        </td>
      </tr>

      <!-- 🧩 Edit Modal -->
      <div class="modal fade" id="editModal<?php echo e($t->id); ?>" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content">
            <div class="modal-header bg-dark text-white">
              <h5 class="modal-title">Editar Tractor</h5>
              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
              <form class="editTractorForm" data-id="<?php echo e($t->id); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="text" name="unidad" class="form-control mb-2" value="<?php echo e($t->unidad); ?>" placeholder="Unidad" required>
                <input type="text" name="brand" class="form-control mb-2" value="<?php echo e($t->brand); ?>" placeholder="Marca" required>
                <input type="text" name="make" class="form-control mb-2" value="<?php echo e($t->make); ?>" placeholder="Modelo" required>
                <input type="text" name="plate" class="form-control mb-2" value="<?php echo e($t->plate); ?>" placeholder="Placa" required>
                <input type="text" name="serie" class="form-control mb-2" value="<?php echo e($t->serie); ?>" placeholder="Serie" required>

                <select name="status" class="form-select mb-2">
                  <?php $__currentLoopData = array_keys($statuses); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option <?php echo e($t->status == $estado ? 'selected' : ''); ?>><?php echo e($estado); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <select name="conductor_id" class="form-select mb-3">
                  <option value="">Ninguno</option>
                  <?php $__currentLoopData = $conductores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c->id); ?>" <?php echo e($t->conductor_id == $c->id ? 'selected' : ''); ?>>
                      <?php echo e($c->first_name); ?> <?php echo e($c->last_name); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <button type="submit" class="btn btn-primary-custom w-100">Guardar Cambios</button>
              </form>
            </div>
          </div>
        </div>
      </div>

      <!-- 🔗 Assign Modal -->
      <div class="modal fade" id="assignModal<?php echo e($t->id); ?>" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
          <div class="modal-content">
            <div class="modal-header bg-primary text-white">
              <h5 class="modal-title">Asignar Conductor, Remolques y Dolly a <?php echo e($t->unidad); ?></h5>
              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
              <form class="assignForm" data-id="<?php echo e($t->id); ?>">
                <?php echo csrf_field(); ?>

                <!-- 👷 Conductor -->
                <h6>Conductor</h6>
                <select name="conductor_id" class="form-select mb-3">
                  <option value="">Ninguno</option>
                  <?php $__currentLoopData = $conductores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c->id); ?>" <?php echo e($t->conductor_id == $c->id ? 'selected' : ''); ?>>
                      <?php echo e($c->first_name); ?> <?php echo e($c->last_name); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <!-- 🚛 Remolques -->
                <h6>Remolques (pueden ser hasta 2)</h6>
                <select name="remolques[]" class="form-select mb-3 remolques-select" multiple>
                  <?php $__currentLoopData = $remolquesDisponibles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($r->id); ?>"
                      <?php echo e(in_array($r->id, DB::table('remolques')->where('tractor_id', $t->id)->pluck('id')->toArray()) ? 'selected' : ''); ?>>
                      <?php echo e($r->unidad); ?> - <?php echo e($r->placa); ?> (<?php echo e($r->status); ?>)
                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <small class="text-muted">
                  Mantén presionado Ctrl (Windows) o Cmd (Mac) para seleccionar más de uno.
                </small>

                <!-- 🔩 Dolly -->
                <h6 class="mt-3">Dolly (solo 1)</h6>
                <select name="dolly_id" class="form-select mb-3">
                  <option value="">Ninguno</option>
                  <?php $__currentLoopData = $dollysDisponibles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($d->id); ?>" 
                      <?php echo e(DB::table('dollys')->where('tractor_id', $t->id)->value('id') == $d->id ? 'selected' : ''); ?>>
                      <?php echo e($d->unidad); ?> - <?php echo e($d->anio); ?> (<?php echo e($d->status); ?>)
                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <button type="submit" class="btn btn-primary-custom w-100 mt-3">
                  Guardar Asignación
                </button>
              </form>
            </div>
          </div>
        </div>
      </div>

      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
  </table>
</div>


    <div class="pagination-container p-3">
      <?php echo e($tractores->links('pagination::bootstrap-5')); ?>

    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>


<script>
$(function() {
  $('.remolques-select').select2({
    width: '100%',
    maximumSelectionLength: 2,
    placeholder: "Selecciona hasta 2 remolques",
    allowClear: true
  });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', ()=> {
  const csrf = document.querySelector('meta[name="csrf-token"]').content;

  // âœ… Assign form
  document.querySelectorAll('.assignForm').forEach(f => {
    f.addEventListener('submit', async e => {
      e.preventDefault();
      const id = f.dataset.id;
      const res = await fetch(`/tractores/${id}/assign`, {
        method: 'POST',
        headers: { 'X-CSRF-TOKEN': csrf, 'Accept': 'application/json' },
        body: new FormData(f)
      });
      const d = await res.json();

      if (d.success) {
        Swal.fire({
          icon: 'success',
          title: '¡Asignaciones guardadas!',
          text: 'El conductor, remolques y dolly se han actualizado correctamente.',
          confirmButtonColor: '#FF4E02'
        }).then(() => location.reload());
      } else {
        Swal.fire({ icon: 'error', title: 'Error', text: d.message || 'Error al guardar.', confirmButtonColor: '#d33' });
      }
    });
  });

  // âœ… Edit form
  document.querySelectorAll('.editTractorForm').forEach(f => {
    f.addEventListener('submit', async e => {
      e.preventDefault();
      const id = f.dataset.id;
      const res = await fetch(`/tractores/${id}`, {
        method: 'POST',
        headers: { 'X-CSRF-TOKEN': csrf, 'X-HTTP-Method-Override': 'PUT', 'Accept': 'application/json' },
        body: new FormData(f)
      });
      const d = await res.json();

      if (d.success) {
        Swal.fire({
          icon: 'success',
          title: '¡Tractor actualizado!',
          text: 'La informacion del tractor se guardo correctamente.',
          confirmButtonColor: '#FF4E02'
        }).then(() => location.reload());
      } else {
        Swal.fire({ icon: 'error', title: 'Error', text: d.message || 'Error al actualizar.', confirmButtonColor: '#d33' });
      }
    });
  });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', () => {
  if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
    console.log('✅ Bootstrap Modal loaded correctly');
  } else {
    console.error('❌ Bootstrap Modal not found or overwritten');
  }
});
</script>


<script>
document.addEventListener('DOMContentLoaded', () => {
    // Filters
    const filterBrand = document.getElementById('filterBrand');
    const filterPlate = document.getElementById('filterPlate');
    const filterStatus = document.getElementById('filterStatus');
    const rows = document.querySelectorAll('#tractoresTable tbody tr');
    function filterTable() {
        const b = filterBrand.value.toLowerCase();
        const p = filterPlate.value.toLowerCase();
        const s = filterStatus.value;
        rows.forEach(r => {
            const brand = r.cells[1].innerText.toLowerCase();
            const plate = r.cells[3].innerText.toLowerCase();
            const status = r.cells[4].innerText.trim();
            const show = (!b || brand.includes(b)) && (!p || plate.includes(p)) && (!s || status === s);
            r.style.display = show ? '' : 'none';
        });
    }
    [filterBrand, filterPlate, filterStatus].forEach(el => el.addEventListener('input', filterTable));

    // Store new tractor
    document.getElementById('newTractorForm').addEventListener('submit', e => {
        e.preventDefault();
        fetch('<?php echo e(route('tractores.store')); ?>', {
            method: 'POST',
            headers: {'X-CSRF-TOKEN': e.target.querySelector('[name="_token"]').value, 'Accept': 'application/json'},
            body: new FormData(e.target)
        }).then(r=>r.json()).then(d=>{if(d.success){alert('Tractor agregado'); location.reload();}});
    });

    // Update tractor
    document.querySelectorAll('.editTractorForm').forEach(f=>{
        f.addEventListener('submit', e=>{
            e.preventDefault();
            const id=f.dataset.id;
            fetch(`/tractores/${id}`, {
                method: 'POST',
                headers: {'X-CSRF-TOKEN': f.querySelector('[name="_token"]').value,'X-HTTP-Method-Override':'PUT','Accept':'application/json'},
                body: new FormData(f)
            }).then(r=>r.json()).then(d=>{if(d.success){alert('Actualizado correctamente');location.reload();}});
        });
    });
});
</script>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/comercializadora/public_html/app.jdcomercializadora.com/resources/views/tractores/index.blade.php ENDPATH**/ ?>