

<?php $__env->startSection('title', 'Dollys - Trainsa'); ?>

<?php $__env->startSection('content'); ?>

<body>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Dollys</h1>
    <p class="page-subtitle">Gestión de dollys y su información técnica.</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Dollys</p>
        <h2 class="stats-value"><?php echo e($total); ?></h2>
      </div>
    </div>

    <?php
      $statuses = [
        'Activo' => 'success',
        'Inactivo' => 'secondary',
        'Ocupado' => 'warning',
      ];
    ?>

    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado => $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card <?php echo e($class); ?>">
          <p class="stats-title"><?php echo e($estado); ?></p>
          <h2 class="stats-value"><?php echo e($por_estado[$estado] ?? 0); ?></h2>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>

  <!-- 🚛 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Dollys</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newDollyModal">
        <i class="fas fa-plus me-2"></i>Nuevo Dolly
      </button>
    </div>

    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterUnidad" class="form-control" placeholder="Buscar por unidad...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterPlaca" class="form-control" placeholder="Buscar por placa...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Activo</option>
            <option>Inactivo</option>
            <option>Ocupado</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="dollysTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Unidad</th>
            <th>Marca</th>
            <th>Año</th>
            <th>Placa</th>
            <th>Estado</th>
            <th>Documentos</th>
            <th>Tractor</th>
            <th>Conductor</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $dollys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($d->id); ?></td>
            <td><?php echo e($d->unidad); ?></td>
            <td><?php echo e($d->marca ?? '-'); ?></td>
            <td><?php echo e($d->anio ?? '-'); ?></td>
            <td><?php echo e($d->placa ?? '-'); ?></td>
            <td>
              <span class="badge 
                <?php switch($d->status):
                  case ('Activo'): ?> badge-success <?php break; ?>
                  <?php case ('Inactivo'): ?> badge-secondary <?php break; ?>
                  <?php case ('Ocupado'): ?> badge-warning <?php break; ?>
                  <?php default: ?> badge-light
                <?php endswitch; ?>">
                <?php echo e($d->status); ?>

              </span>
            </td>
            <td>
              <?php if($d->fisico_mecanica_doc): ?>
                <a href="<?php echo e(asset('storage/'.$d->fisico_mecanica_doc)); ?>" target="_blank" title="Fisico Mecanica"><i class="fas fa-file-alt text-primary"></i></a>
              <?php endif; ?>
            </td>
            <td><?php echo e($d->tractor_unidad ?? 'No Asignado'); ?></td>
            <td><?php echo e($d->conductor_name ?? 'No Asignado'); ?></td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($d->id); ?>">
                <i class="fas fa-edit"></i>
              </button>
            </td>
          </tr>

          <!-- Edit Modal -->
          <div class="modal fade" id="editModal<?php echo e($d->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Dolly</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editDollyForm" data-id="<?php echo e($d->id); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                      <div class="col-md-6">
                        <input type="text" name="unidad" class="form-control mb-2" value="<?php echo e($d->unidad); ?>" placeholder="Unidad" required>
                        <input type="text" name="marca" class="form-control mb-2" value="<?php echo e($d->marca); ?>" placeholder="Marca">
                        <input type="number" name="anio" class="form-control mb-2" value="<?php echo e($d->anio); ?>" placeholder="Año">
                        <input type="text" name="placa" class="form-control mb-2" value="<?php echo e($d->placa); ?>" placeholder="Placa">
                        <input type="text" name="niv" class="form-control mb-2" value="<?php echo e($d->niv); ?>" placeholder="Número de Serie (NIV)">
                        <input type="text" name="color" class="form-control mb-2" value="<?php echo e($d->color); ?>" placeholder="Color">
                      </div>
                      <div class="col-md-6">
                        <h6 class="mt-2">🔧 Físico Mecánica</h6>
                        <input type="text" name="fisico_mecanica_folio" class="form-control mb-2" value="<?php echo e($d->fisico_mecanica_folio); ?>" placeholder="Folio">
                        <input type="date" name="fisico_mecanica_expedicion" class="form-control mb-2" value="<?php echo e($d->fisico_mecanica_expedicion); ?>">
                        <input type="date" name="fisico_mecanica_expiracion" class="form-control mb-2" value="<?php echo e($d->fisico_mecanica_expiracion); ?>">
                        <input type="file" name="fisico_mecanica_doc" class="form-control mb-3">
                        
                        <select name="status" class="form-select mb-3">
                          <?php $__currentLoopData = array_keys($statuses); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e($d->status == $estado ? 'selected' : ''); ?>><?php echo e($estado); ?></option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      </div>
                    </div>
                    <button type="submit" class="btn btn-primary-custom w-100 mt-2">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      <?php echo e($dollys->links('pagination::bootstrap-5')); ?>

    </div>
  </div>
</div>

<!-- ➕ Nuevo Dolly Modal -->
<div class="modal fade" id="newDollyModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Dolly</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newDollyForm" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="row">
            <div class="col-md-6">
              <input type="text" name="unidad" class="form-control mb-2" placeholder="Unidad" required>
              <input type="text" name="marca" class="form-control mb-2" placeholder="Marca">
              <input type="number" name="anio" class="form-control mb-2" placeholder="Año">
              <input type="text" name="placa" class="form-control mb-2" placeholder="Placa">
              <input type="text" name="niv" class="form-control mb-2" placeholder="Número de Serie (NIV)">
              <input type="text" name="color" class="form-control mb-2" placeholder="Color">
            </div>
            <div class="col-md-6">
              <h6 class="mt-2">🔧 Físico Mecánica</h6>
              <input type="text" name="fisico_mecanica_folio" class="form-control mb-2" placeholder="Folio">
              <input type="date" name="fisico_mecanica_expedicion" class="form-control mb-2">
              <input type="date" name="fisico_mecanica_expiracion" class="form-control mb-2">
              <input type="file" name="fisico_mecanica_doc" class="form-control mb-3">
              <select name="status" class="form-select mb-3">
                <?php $__currentLoopData = array_keys($statuses); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option><?php echo e($estado); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
          </div>
          <button type="submit" class="btn btn-primary-custom w-100 mt-2">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script>
document.addEventListener('DOMContentLoaded', ()=>{
  const csrf=document.querySelector('meta[name="csrf-token"]').content;
  const rows=document.querySelectorAll('#dollysTable tbody tr');
  const fUnidad=document.getElementById('filterUnidad');
  const fPlaca=document.getElementById('filterPlaca');
  const fStatus=document.getElementById('filterStatus');

  function filter(){
    const u=fUnidad.value.toLowerCase();
    const p=fPlaca.value.toLowerCase();
    const s=fStatus.value;
    rows.forEach(r=>{
      const unidad=r.cells[1].innerText.toLowerCase();
      const placa=r.cells[4].innerText.toLowerCase();
      const st=r.cells[5].innerText.trim();
      const show=(!u||unidad.includes(u))&&(!p||placa.includes(p))&&(!s||st===s);
      r.style.display=show?'':'none';
    });
  }
  [fUnidad,fPlaca,fStatus].forEach(el=>{
    el.addEventListener('input',filter);
    el.addEventListener('change',filter);
  });

  // Create
  document.getElementById('newDollyForm').addEventListener('submit',async e=>{
    e.preventDefault();
    const res=await fetch('<?php echo e(route('dollys.store')); ?>',{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'Accept':'application/json'},body:new FormData(e.target)});
    const d=await res.json();
    if(d.success){alert('Dolly agregado exitosamente');location.reload();}
  });

  // Edit
  document.querySelectorAll('.editDollyForm').forEach(f=>{
    f.addEventListener('submit',async e=>{
      e.preventDefault();
      const id=f.dataset.id;
      const res=await fetch(`/dollys/${id}`,{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'X-HTTP-Method-Override':'PUT','Accept':'application/json'},body:new FormData(f)});
      const d=await res.json();
      if(d.success){alert('Dolly actualizado');location.reload();}
    });
  });
});
</script>
</body>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/trainsa/public_html/resources/views/dollys/index.blade.php ENDPATH**/ ?>