

<?php $__env->startSection('title', 'Camiones - J&D'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Camiones</h1>
    <p class="page-subtitle">Gestión completa de camiones del sistema Comercializadora J&D</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Camiones</p>
        <h2 class="stats-value"><?php echo e($total); ?></h2>
      </div>
    </div>

    <?php
      $statuses = [
        'Activo' => 'success',
        'Inactivo' => 'inactive',
        'En Taller' => 'danger',
        'Sin Asignar' => 'secondary',
      ];
    ?>

    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado => $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card <?php echo e($class); ?>">
          <p class="stats-title"><?php echo e($estado); ?></p>
          <h2 class="stats-value"><?php echo e($por_estado[$estado] ?? 0); ?></h2>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>

  <!-- 🚚 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Camiones</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newCamionModal">
        <i class="fas fa-plus me-2"></i>Nuevo Camión
      </button>
    </div>

    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterMarca" class="form-control" placeholder="Buscar por marca...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterPlaca" class="form-control" placeholder="Buscar por placa...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Activo</option>
            <option>Inactivo</option>
            <option>En Taller</option>
            <option>Sin Asignar</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="camionesTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>Unidad</th>
            <th>Marca</th>
            <th>Modelo</th>
            <th>Placa</th>
            <th>VIN</th>
            <th>Documentos</th>
            <th>Expira</th>
            <th>Capacidad</th>
            <th>Conductor</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $camiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><strong><?php echo e($c->unidad); ?></strong></td>
            <td><?php echo e($c->marca); ?></td>
            <td><?php echo e($c->modelo); ?></td>
            <td><?php echo e($c->placa); ?></td>
            <td><?php echo e($c->vin); ?></td>

            <!-- 📄 Both documents -->
            <td>
              <?php
                $hasDocs = $c->poliza_documento || $c->tarjeta_circulacion;
              ?>
              <?php if($hasDocs): ?>
                <?php if($c->poliza_documento): ?>
                  <a href="<?php echo e(asset('storage/'.$c->poliza_documento)); ?>" target="_blank" class="d-block text-primary">
                    📄 Póliza (<?php echo e($c->poliza_numero ?? 'N/A'); ?>)
                  </a>
                <?php endif; ?>
                <?php if($c->tarjeta_circulacion): ?>
                  <a href="<?php echo e(asset('storage/'.$c->tarjeta_circulacion)); ?>" target="_blank" class="d-block text-success">
                    🚗 Tarjeta Circulación
                  </a>
                <?php endif; ?>
              <?php else: ?>
                <span class="text-muted">Sin documentos</span>
              <?php endif; ?>
            </td>

            <td><?php echo e($c->fecha_expiracion_seguro); ?></td>
            <td><?php echo e($c->capacidad_carga); ?></td>

            <td>
              <?php if($c->conductor_name): ?>
                <span class="fw-semibold"><?php echo e($c->conductor_name); ?></span><br>
                <small class="text-muted"><?php echo e($c->license_number ?? 'Sin licencia'); ?></small>
              <?php else: ?>
                <span class="text-muted">Sin asignar</span>
              <?php endif; ?>
            </td>

            <td>
              <span class="badge
                <?php switch($c->status):
                  case ('Activo'): ?> badge-active <?php break; ?>
                  <?php case ('Inactivo'): ?> badge-inactive <?php break; ?>
                  <?php case ('En Taller'): ?> badge-danger <?php break; ?>
                  <?php case ('Sin Asignar'): ?> badge-secondary <?php break; ?>
                  <?php default: ?> badge-secondary
                <?php endswitch; ?>">
                <?php echo e($c->status); ?>

              </span>
            </td>

            <td class="text-center">
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($c->id); ?>">
                <i class="fas fa-edit"></i>
              </button>
            </td>
          </tr>

          <!-- 🧩 Edit Modal -->
          <div class="modal fade" id="editModal<?php echo e($c->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Camión</h5>
                  <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editCamionForm" data-id="<?php echo e($c->id); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                      <div class="col-md-6 mb-2"><input type="text" name="unidad" class="form-control" value="<?php echo e($c->unidad); ?>" placeholder="Unidad" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="placa" class="form-control" value="<?php echo e($c->placa); ?>" placeholder="Placa" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="marca" class="form-control" value="<?php echo e($c->marca); ?>" placeholder="Marca" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="modelo" class="form-control" value="<?php echo e($c->modelo); ?>" placeholder="Modelo" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="vin" class="form-control" value="<?php echo e($c->vin); ?>" placeholder="VIN"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="poliza_numero" class="form-control" value="<?php echo e($c->poliza_numero); ?>" placeholder="Número de póliza"></div>
                      <div class="col-md-6 mb-2"><input type="date" name="fecha_expiracion_seguro" class="form-control" value="<?php echo e($c->fecha_expiracion_seguro); ?>"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="capacidad_carga" class="form-control" value="<?php echo e($c->capacidad_carga); ?>" placeholder="Capacidad de carga"></div>

                      <!-- 📤 Files -->
                      <div class="col-md-6 mb-2">
                        <label>Póliza Documento</label>
                        <input type="file" name="poliza_documento" class="form-control">
                        <?php if($c->poliza_documento): ?>
                          <a href="<?php echo e(asset('storage/'.$c->poliza_documento)); ?>" target="_blank" class="small d-block mt-1">📄 Ver actual</a>
                        <?php endif; ?>
                      </div>

                      <div class="col-md-6 mb-2">
                        <label>Tarjeta Circulación</label>
                        <input type="file" name="tarjeta_circulacion" class="form-control">
                        <?php if($c->tarjeta_circulacion): ?>
                          <a href="<?php echo e(asset('storage/'.$c->tarjeta_circulacion)); ?>" target="_blank" class="small d-block mt-1">🚗 Ver actual</a>
                        <?php endif; ?>
                      </div>

                      <div class="col-md-12 mb-3">
                        <label for="driver_id" class="form-label fw-bold">Conductor Asignado</label>
                        <select name="driver_id" class="form-select">
                          <option value="">— Ninguno —</option>
                          <?php $__currentLoopData = $conductores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $con): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($con->id); ?>" <?php echo e($c->driver_id == $con->id ? 'selected' : ''); ?>>
                              <?php echo e($con->first_name); ?> <?php echo e($con->last_name); ?> (<?php echo e($con->license_number ?? 'Sin Licencia'); ?>)
                            </option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      </div>

                      <div class="col-md-12 mb-3">
                        <select name="status" class="form-select">
                          <option <?php echo e($c->status=='Activo'?'selected':''); ?>>Activo</option>
                          <option <?php echo e($c->status=='Inactivo'?'selected':''); ?>>Inactivo</option>
                          <option <?php echo e($c->status=='En Taller'?'selected':''); ?>>En Taller</option>
                          <option <?php echo e($c->status=='Sin Asignar'?'selected':''); ?>>Sin Asignar</option>
                        </select>
                      </div>
                    </div>
                    <button type="submit" class="btn btn-primary-custom w-100 mt-2">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      <?php echo e($camiones->links('pagination::bootstrap-5')); ?>

    </div>
  </div>
</div>

<!-- ➕ Nuevo Camión Modal -->
<div class="modal fade" id="newCamionModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Camión</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newCamionForm" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="row">
            <div class="col-md-6 mb-2"><input type="text" name="unidad" class="form-control" placeholder="Unidad" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="placa" class="form-control" placeholder="Placa" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="marca" class="form-control" placeholder="Marca" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="modelo" class="form-control" placeholder="Modelo" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="vin" class="form-control" placeholder="VIN"></div>
            <div class="col-md-6 mb-2"><input type="text" name="poliza_numero" class="form-control" placeholder="Número de póliza"></div>
            <div class="col-md-6 mb-2"><input type="date" name="fecha_expiracion_seguro" class="form-control"></div>
            <div class="col-md-6 mb-2"><input type="text" name="capacidad_carga" class="form-control" placeholder="Capacidad de carga"></div>

            <!-- 📤 Uploads -->
            <div class="col-md-6 mb-2"><label>Póliza Documento</label><input type="file" name="poliza_documento" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Tarjeta Circulación</label><input type="file" name="tarjeta_circulacion" class="form-control"></div>

            <div class="col-md-12 mb-3">
              <label for="driver_id" class="form-label fw-bold">Conductor Asignado</label>
              <select name="driver_id" class="form-select">
                <option value="">— Ninguno —</option>
                <?php $__currentLoopData = $conductores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $con): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($con->id); ?>"><?php echo e($con->first_name); ?> <?php echo e($con->last_name); ?> (<?php echo e($con->license_number ?? 'Sin Licencia'); ?>)</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>

            <div class="col-md-12 mb-3">
              <select name="status" class="form-select">
                <option>Activo</option>
                <option>Inactivo</option>
                <option>En Taller</option>
                <option>Sin Asignar</option>
              </select>
            </div>
          </div>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<script>
document.addEventListener('DOMContentLoaded', ()=> {
  const csrf = document.querySelector('meta[name="csrf-token"]').content;
  const showAlert = (icon, title, text, reload=false) => {
    Swal.fire({icon, title, text, confirmButtonColor:'#FF4E02'}).then(()=>{if(reload)location.reload();});
  };

  // ➕ New camion
  document.getElementById('newCamionForm').addEventListener('submit', async e=>{
    e.preventDefault();
    const res = await fetch('<?php echo e(route('camiones.store')); ?>', {
      method:'POST',
      headers:{'X-CSRF-TOKEN':csrf,'Accept':'application/json'},
      body:new FormData(e.target)
    });
    const d = await res.json();
    if(d.success) showAlert('success','Camión agregado','El nuevo camión fue registrado correctamente.',true);
    else showAlert('error','Error','No se pudo guardar el camión.');
  });

  // ✏️ Edit camion
  document.querySelectorAll('.editCamionForm').forEach(f=>{
    f.addEventListener('submit', async e=>{
      e.preventDefault();
      const id = f.dataset.id;
      const res = await fetch(`/camiones/${id}`, {
        method:'POST',
        headers:{'X-CSRF-TOKEN':csrf,'X-HTTP-Method-Override':'PUT','Accept':'application/json'},
        body:new FormData(f)
      });
      const d = await res.json();
      if(d.success) showAlert('success','Camión actualizado','Los datos se guardaron correctamente.',true);
      else showAlert('error','Error','Error al actualizar el camión.');
    });
  });

  // 🔎 Filters
  const fMarca=document.getElementById('filterMarca'), fPlaca=document.getElementById('filterPlaca'), fStatus=document.getElementById('filterStatus');
  const rows=document.querySelectorAll('#camionesTable tbody tr');
  const filter=()=>{
    const m=fMarca.value.toLowerCase(), p=fPlaca.value.toLowerCase(), s=fStatus.value;
    rows.forEach(r=>{
      const marca=r.cells[1].innerText.toLowerCase(), placa=r.cells[3].innerText.toLowerCase(), status=r.cells[9].innerText.trim();
      const show=(!m||marca.includes(m))&&(!p||placa.includes(p))&&(!s||status===s);
      r.style.display=show?'':'none';
    });
  };
  [fMarca,fPlaca,fStatus].forEach(el=>{el.addEventListener('input',filter);el.addEventListener('change',filter);});
});
</script>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/comercializadora/public_html/app.jdcomercializadora.com/resources/views/camiones/index.blade.php ENDPATH**/ ?>