<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class RemolqueController extends Controller
{
    public function index()
{
    $remolques = DB::table('remolques as r')
        ->leftJoin('tractores as t', 'r.tractor_id', '=', 't.id')
        ->leftJoin('conductores as c1', 'r.conductor_id', '=', 'c1.id')
        ->leftJoin('conductores as c2', 't.conductor_id', '=', 'c2.id')
        ->select(
            'r.*',
            't.unidad as tractor_unidad', // ✅ changed from plate → unidad
            DB::raw("COALESCE(CONCAT(c1.first_name, ' ', c1.last_name), CONCAT(c2.first_name, ' ', c2.last_name)) as conductor_name")
        )
        ->orderBy('r.id', 'desc')
        ->paginate(10);

    $total = DB::table('remolques')->count();

    $por_estado = DB::table('remolques')
        ->select('status', DB::raw('COUNT(*) as total'))
        ->groupBy('status')
        ->get()
        ->pluck('total', 'status');

    return view('remolques.index', compact('remolques', 'total', 'por_estado'));
}


    public function store(Request $request)
    {
        $validated = $request->validate([
            'unidad' => 'required|string|max:100',
            'tipo_remolque' => 'required|string|max:100',
            'marca' => 'nullable|string|max:100',
            'anio' => 'nullable|integer',
            'placa' => 'nullable|string|max:100|unique:remolques,placa',
            'niv' => 'nullable|string|max:100',
            'color' => 'nullable|string|max:50',
            'status' => 'required|string|max:50',
            'poliza_seguro_doc' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
            'fisico_mecanica_doc' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
            'tarjeta_circulacion_doc' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
        ]);

        // Handle file uploads
        $paths = [];
        foreach (['poliza_seguro_doc', 'fisico_mecanica_doc', 'tarjeta_circulacion_doc'] as $fileField) {
            if ($request->hasFile($fileField)) {
                $paths[$fileField] = $request->file($fileField)->store('remolques_docs', 'public');
            }
        }

        DB::table('remolques')->insert(array_merge($validated, $paths));

        return response()->json(['success' => true]);
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'unidad' => 'required|string|max:100',
            'tipo_remolque' => 'required|string|max:100',
            'marca' => 'nullable|string|max:100',
            'anio' => 'nullable|integer',
            'placa' => 'nullable|string|max:100',


            'niv' => 'nullable|string|max:100',
            'color' => 'nullable|string|max:50',
            'status' => 'required|string|max:50',
            'poliza_seguro_doc' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
            'fisico_mecanica_doc' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
            'tarjeta_circulacion_doc' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
        ]);

        $updateData = $validated;

        // Handle file uploads (replace old ones)
        foreach (['poliza_seguro_doc', 'fisico_mecanica_doc', 'tarjeta_circulacion_doc'] as $fileField) {
            if ($request->hasFile($fileField)) {
                $path = $request->file($fileField)->store('remolques_docs', 'public');
                $updateData[$fileField] = $path;
            }
        }

        DB::table('remolques')->where('id', $id)->update($updateData);

        return response()->json(['success' => true]);
    }
}
