@extends('layouts.dashboard')

@section('title', 'Conductores - Trainsa')

@section('content')
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Conductores</h1>
    <p class="page-subtitle">Gestión completa de conductores del sistema Trainsa.</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Conductores</p>
        <h2 class="stats-value">{{ $total }}</h2>
      </div>
    </div>

    @php
      $statuses = [
        'Activo' => 'active',
        'Inactivo' => 'inactive',
        'Sin Camion' => 'no-truck',
        'Sin Licencia' => 'no-license',
        'En Descanso' => 'resting',
      ];
    @endphp

    @foreach($statuses as $estado => $class)
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card {{ $class }}">
          <p class="stats-title">{{ $estado }}</p>
          <h2 class="stats-value">{{ $por_estado[$estado] ?? 0 }}</h2>
        </div>
      </div>
    @endforeach
  </div>

  <!-- 🚛 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Conductores</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newConductorModal">
        <i class="fas fa-plus me-2"></i>Nuevo Conductor
      </button>
    </div>

    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterName" class="form-control" placeholder="Buscar por nombre...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterLicense" class="form-control" placeholder="Buscar por licencia...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Activo</option>
            <option>Inactivo</option>
            <option>Sin Camion</option>
            <option>Sin Licencia</option>
            <option>En Descanso</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="conductoresTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Foto</th>
            <th>Nombre</th>
            
            <th>Teléfono</th>
            <th>Licencia</th>
            <th>Tipo</th>
            <th>Vencimiento Licencia</th>
            <th>Apto Médico</th>
            <th>Tractor</th>
            <th>Estado</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          @foreach($conductores as $c)
          <tr>
            <td>{{ $c->worker_number }}</td>
            <td>
              @if($c->profile_pic)
                <img src="{{ asset('storage/'.$c->profile_pic) }}" width="45" height="45" class="rounded-circle object-fit-cover">
              @else
                <i class="fa-solid fa-user text-secondary fs-4"></i>
              @endif
            </td>
            <td>{{ $c->first_name }} {{ $c->last_name }}</td>
            
            <td>{{ $c->phone_number }}</td>
            <td>{{ $c->license_number }}</td>
            <td>{{ $c->license_type }}</td>
            <td>{{ $c->license_expiration }}</td>
            <td>{{ $c->medical_exam_expiration }}</td>
            <td>{{ $c->tractor_unidad ?? 'Ninguno' }}</td>
            <td>
              <span class="badge 
                @switch($c->status)
                  @case('Activo') badge-active @break
                  @case('Inactivo') badge-inactive @break
                  @case('Sin Camion') badge-no-truck @break
                  @case('Sin Licencia') badge-no-license @break
                  @case('En Descanso') badge-resting @break
                  @default badge-inactive
                @endswitch">
                {{ $c->status }}
              </span>
            </td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#viewModal{{ $c->id }}"><i class="fas fa-eye"></i></button>
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal{{ $c->id }}"><i class="fas fa-edit"></i></button>
            </td>
          </tr>

          <!-- View Modal -->
          <div class="modal fade" id="viewModal{{ $c->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Detalles del Conductor</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <div class="row">
                    <div class="col-md-4 text-center">
                      @if($c->profile_pic)
                        <img src="{{ asset('storage/'.$c->profile_pic) }}" width="120" class="rounded mb-2">
                      @endif
                    </div>
                    <div class="col-md-8">
                      <p><strong>Nombre:</strong> {{ $c->first_name }} {{ $c->last_name }}</p>
                      <p><strong>Email:</strong> {{ $c->email }}</p>
                      <p><strong>Teléfono:</strong> {{ $c->phone_number }}</p>
                      <p><strong>Licencia:</strong> {{ $c->license_number }} ({{ $c->license_type }})</p>
                      <p><strong>Expira:</strong> {{ $c->license_expiration }}</p>
                      <p><strong>Apto Médico:</strong> {{ $c->medical_exam_number }} - {{ $c->medical_exam_expiration }}</p>
                      <p><strong>Estado:</strong> {{ $c->status }}</p>
                    </div>
                  </div>

                  <hr>
                  <p>
                    @if($c->license_front)
                      <a href="{{ asset('storage/'.$c->license_front) }}" target="_blank">📄 Licencia Frente</a><br>
                    @endif
                    @if($c->license_back)
                      <a href="{{ asset('storage/'.$c->license_back) }}" target="_blank">📄 Licencia Reverso</a><br>
                    @endif
                    @if($c->rfc_document)
                      <a href="{{ asset('storage/'.$c->rfc_document) }}" target="_blank">📄 RFC</a><br>
                    @endif
                    @if($c->medical_exam_document)
                      <a href="{{ asset('storage/'.$c->medical_exam_document) }}" target="_blank">📄 Apto Médico</a><br>
                    @endif
                  </p>
                </div>
              </div>
            </div>
          </div>

          <!-- Edit Modal -->
          <div class="modal fade" id="editModal{{ $c->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Conductor</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editConductorForm" data-id="{{ $c->id }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                      <div class="col-md-6 mb-2"><input type="text" name="first_name" class="form-control" value="{{ $c->first_name }}" placeholder="Nombre" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="last_name" class="form-control" value="{{ $c->last_name }}" placeholder="Apellido" required></div>
                      <div class="col-md-6 mb-2"><input type="email" name="email" class="form-control" value="{{ $c->email }}" placeholder="Email" required></div>
                      <div class="col-md-6 mb-2"><input type="text" name="phone_number" class="form-control" value="{{ $c->phone_number }}" placeholder="Teléfono"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="worker_number" class="form-control" value="{{ $c->worker_number }}" placeholder="Número de Trabajador"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="rfc_id" class="form-control" value="{{ $c->rfc_id }}" placeholder="RFC ID"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="license_number" class="form-control" value="{{ $c->license_number }}" placeholder="Número de Licencia"></div>
                      <div class="col-md-6 mb-2">
                        <select name="license_type" class="form-select">
                          <option value="">Tipo de Licencia</option>
                          <option {{ $c->license_type=='B'?'selected':'' }}>B</option>
                          <option {{ $c->license_type=='E'?'selected':'' }}>E</option>
                        </select>
                      </div>
                      <div class="col-md-6 mb-2"><input type="date" name="license_expiration" class="form-control" value="{{ $c->license_expiration }}" placeholder="Vencimiento Licencia"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="medical_exam_number" class="form-control" value="{{ $c->medical_exam_number }}" placeholder="Número Apto Médico"></div>
                      <div class="col-md-6 mb-2"><input type="date" name="medical_exam_expiration" class="form-control" value="{{ $c->medical_exam_expiration }}" placeholder="Vencimiento Apto Médico"></div>
                      <div class="col-md-6 mb-2"><input type="text" name="social_security_number" class="form-control" value="{{ $c->social_security_number }}" placeholder="Seguro Social"></div>

                      <!-- 🖼️ File Uploads -->
                      <div class="col-md-6 mb-2"><label>Foto de Perfil</label><input type="file" name="profile_pic" class="form-control"></div>
                      <div class="col-md-6 mb-2"><label>Licencia Frente</label><input type="file" name="license_front" class="form-control"></div>
                      <div class="col-md-6 mb-2"><label>Licencia Reverso</label><input type="file" name="license_back" class="form-control"></div>
                      <div class="col-md-6 mb-2"><label>Documento RFC</label><input type="file" name="rfc_document" class="form-control"></div>
                      <div class="col-md-6 mb-2"><label>Documento Apto Médico</label><input type="file" name="medical_exam_document" class="form-control"></div>

                      <div class="col-md-12 mb-2">
                        <select name="status" class="form-select">
                          <option {{ $c->status=='Activo'?'selected':'' }}>Activo</option>
                          <option {{ $c->status=='Inactivo'?'selected':'' }}>Inactivo</option>
                          <option {{ $c->status=='Sin Camion'?'selected':'' }}>Sin Camion</option>
                          <option {{ $c->status=='Sin Licencia'?'selected':'' }}>Sin Licencia</option>
                          <option {{ $c->status=='En Descanso'?'selected':'' }}>En Descanso</option>
                        </select>
                      </div>
                    </div>
                    <button type="submit" class="btn btn-primary-custom w-100 mt-3">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          @endforeach
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      {{ $conductores->links('pagination::bootstrap-5') }}
    </div>
  </div>
</div>

<!-- ➕ Nuevo Conductor Modal -->
<div class="modal fade" id="newConductorModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Conductor</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newConductorForm" enctype="multipart/form-data">
          @csrf
          <div class="row">
            <div class="col-md-6 mb-2"><input type="text" name="first_name" class="form-control" placeholder="Nombre" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="last_name" class="form-control" placeholder="Apellido" required></div>
            <div class="col-md-6 mb-2"><input type="email" name="email" class="form-control" placeholder="Email" required></div>
            <div class="col-md-6 mb-2"><input type="text" name="phone_number" class="form-control" placeholder="Teléfono"></div>
            <div class="col-md-6 mb-2"><input type="text" name="worker_number" class="form-control" placeholder="Número de Trabajador"></div>
            <div class="col-md-6 mb-2"><input type="text" name="rfc_id" class="form-control" placeholder="RFC ID"></div>
            <div class="col-md-6 mb-2"><input type="text" name="license_number" class="form-control" placeholder="Número de Licencia"></div>
            <div class="col-md-6 mb-2">
              <select name="license_type" class="form-select">
                <option value="">Tipo de Licencia</option>
                <option>B</option>
                <option>E</option>
              </select>
            </div>
            <div class="col-md-6 mb-2"><input type="date" name="license_expiration" class="form-control"></div>
            <div class="col-md-6 mb-2"><input type="text" name="medical_exam_number" class="form-control" placeholder="Número Apto Médico"></div>
            <div class="col-md-6 mb-2"><input type="date" name="medical_exam_expiration" class="form-control"></div>
            <div class="col-md-6 mb-2"><input type="text" name="social_security_number" class="form-control" placeholder="Seguro Social"></div>

            <!-- 🖼️ File uploads -->
            <div class="col-md-6 mb-2"><label>Foto de Perfil</label><input type="file" name="profile_pic" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Licencia Frente</label><input type="file" name="license_front" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Licencia Reverso</label><input type="file" name="license_back" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Documento RFC</label><input type="file" name="rfc_document" class="form-control"></div>
            <div class="col-md-6 mb-2"><label>Documento Apto Médico</label><input type="file" name="medical_exam_document" class="form-control"></div>

            <div class="col-md-12 mb-3">
              <select name="status" class="form-select" required>
                <option>Activo</option>
                <option>Inactivo</option>
                <option>Sin Camion</option>
                <option>Sin Licencia</option>
                <option>En Descanso</option>
              </select>
            </div>
          </div>
          <button type="submit" class="btn btn-primary-custom w-100">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection


<script>
document.addEventListener('DOMContentLoaded', () => {
    const csrf = document.querySelector('meta[name="csrf-token"]').content;

    // 🔹 Helper for SweetAlert notifications
    const showAlert = (icon, title, text, reload = false) => {
        Swal.fire({
            icon,
            title,
            text,
            confirmButtonColor: '#FF4E02'
        }).then(() => {
            if (reload) location.reload();
        });
    };

    // 🔹 New Conductor
    const newForm = document.getElementById('newConductorForm');
    if (newForm) {
        newForm.addEventListener('submit', async e => {
            e.preventDefault(); // stop form reload
            const formData = new FormData(newForm);

            try {
                const res = await fetch('{{ route('conductores.store') }}', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': csrf,
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                const data = await res.json();

                if (data.success) {
                    showAlert('success', 'Conductor agregado', 'El nuevo conductor fue guardado correctamente.', true);
                } else {
                    showAlert('error', 'Error', 'No se pudo guardar el conductor.');
                }
            } catch (error) {
                console.error(error);
                showAlert('error', 'Error', 'Hubo un problema al guardar el conductor.');
            }
        });
    }

    // 🔹 Edit Conductor
    document.querySelectorAll('.editConductorForm').forEach(form => {
        form.addEventListener('submit', async e => {
            e.preventDefault(); // stop reload
            const id = form.dataset.id;
            const formData = new FormData(form);

            try {
                const res = await fetch(`/conductores/${id}`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': csrf,
                        'X-HTTP-Method-Override': 'PUT',
                        'Accept': 'application/json'
                    },
                    body: formData
                });

                const data = await res.json();

                if (data.success) {
                    showAlert('success', 'Conductor actualizado', 'Los datos se guardaron correctamente.', true);
                } else {
                    showAlert('error', 'Error al actualizar', 'Revisa los datos e intenta nuevamente.');
                }
            } catch (error) {
                console.error(error);
                showAlert('error', 'Error', 'Hubo un problema al actualizar el conductor.');
            }
        });
    });

    // 🔹 Filters
    const fName = document.getElementById('filterName');
    const fLic = document.getElementById('filterLicense');
    const fStatus = document.getElementById('filterStatus');
    const rows = document.querySelectorAll('#conductoresTable tbody tr');

    function filter() {
        const n = fName.value.toLowerCase();
        const l = fLic.value.toLowerCase();
        const s = fStatus.value;
        rows.forEach(r => {
            const name = r.cells[2].innerText.toLowerCase();
            const lic = r.cells[5].innerText.toLowerCase();
            const st = r.cells[10].innerText.trim();
            const show = (!n || name.includes(n)) && (!l || lic.includes(l)) && (!s || st === s);
            r.style.display = show ? '' : 'none';
        });
    }

    [fName, fLic, fStatus].forEach(el => {
        el.addEventListener('input', filter);
        el.addEventListener('change', filter);
    });
});
</script>



