@extends('layouts.dashboard')

@section('title', 'Dollys - Trainsa')

@section('content')

<body>
<div class="dashboard-container">
  <div class="page-header">
    <h1 class="page-title">Dollys</h1>
    <p class="page-subtitle">Gestión de dollys y su información técnica.</p>
  </div>

  <!-- 📊 Stats -->
  <div class="row mb-4 justify-content-center">
    <div class="col-md-3 col-sm-6 mb-3">
      <div class="stats-card total">
        <p class="stats-title">Total Dollys</p>
        <h2 class="stats-value">{{ $total }}</h2>
      </div>
    </div>

    @php
      $statuses = [
        'Activo' => 'success',
        'Inactivo' => 'secondary',
        'Ocupado' => 'warning',
      ];
    @endphp

    @foreach($statuses as $estado => $class)
      <div class="col-md-3 col-sm-6 mb-3">
        <div class="stats-card {{ $class }}">
          <p class="stats-title">{{ $estado }}</p>
          <h2 class="stats-value">{{ $por_estado[$estado] ?? 0 }}</h2>
        </div>
      </div>
    @endforeach
  </div>

  <!-- 🚛 Table -->
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Lista de Dollys</h3>
      <button class="btn btn-primary-custom ms-auto" data-bs-toggle="modal" data-bs-target="#newDollyModal">
        <i class="fas fa-plus me-2"></i>Nuevo Dolly
      </button>
    </div>

    <!-- Filters -->
    <div class="p-3 bg-light border-bottom">
      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" id="filterUnidad" class="form-control" placeholder="Buscar por unidad...">
        </div>
        <div class="col-md-4">
          <input type="text" id="filterPlaca" class="form-control" placeholder="Buscar por placa...">
        </div>
        <div class="col-md-4">
          <select id="filterStatus" class="form-select">
            <option value="">Todos los estados</option>
            <option>Activo</option>
            <option>Inactivo</option>
            <option>Ocupado</option>
          </select>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table id="dollysTable" class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Unidad</th>
            <th>Marca</th>
            <th>Año</th>
            <th>Placa</th>
            <th>Estado</th>
            <th>Documentos</th>
            <th>Tractor</th>
            <th>Conductor</th>
            <th class="text-center">Acciones</th>
          </tr>
        </thead>
        <tbody>
          @foreach($dollys as $d)
          <tr>
            <td>{{ $d->id }}</td>
            <td>{{ $d->unidad }}</td>
            <td>{{ $d->marca ?? '-' }}</td>
            <td>{{ $d->anio ?? '-' }}</td>
            <td>{{ $d->placa ?? '-' }}</td>
            <td>
              <span class="badge 
                @switch($d->status)
                  @case('Activo') badge-success @break
                  @case('Inactivo') badge-secondary @break
                  @case('Ocupado') badge-warning @break
                  @default badge-light
                @endswitch">
                {{ $d->status }}
              </span>
            </td>
            <td>
              @if($d->fisico_mecanica_doc)
                <a href="{{ asset('storage/'.$d->fisico_mecanica_doc) }}" target="_blank" title="Fisico Mecanica"><i class="fas fa-file-alt text-primary"></i></a>
              @endif
            </td>
            <td>{{ $d->tractor_unidad ?? 'No Asignado' }}</td>
            <td>{{ $d->conductor_name ?? 'No Asignado' }}</td>
            <td class="text-center">
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#editModal{{ $d->id }}">
                <i class="fas fa-edit"></i>
              </button>
            </td>
          </tr>

          <!-- Edit Modal -->
          <div class="modal fade" id="editModal{{ $d->id }}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
              <div class="modal-content">
                <div class="modal-header bg-dark text-white">
                  <h5 class="modal-title">Editar Dolly</h5>
                  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <form class="editDollyForm" data-id="{{ $d->id }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                      <div class="col-md-6">
                        <input type="text" name="unidad" class="form-control mb-2" value="{{ $d->unidad }}" placeholder="Unidad" required>
                        <input type="text" name="marca" class="form-control mb-2" value="{{ $d->marca }}" placeholder="Marca">
                        <input type="number" name="anio" class="form-control mb-2" value="{{ $d->anio }}" placeholder="Año">
                        <input type="text" name="placa" class="form-control mb-2" value="{{ $d->placa }}" placeholder="Placa">
                        <input type="text" name="niv" class="form-control mb-2" value="{{ $d->niv }}" placeholder="Número de Serie (NIV)">
                        <input type="text" name="color" class="form-control mb-2" value="{{ $d->color }}" placeholder="Color">
                      </div>
                      <div class="col-md-6">
                        <h6 class="mt-2">🔧 Físico Mecánica</h6>
                        <input type="text" name="fisico_mecanica_folio" class="form-control mb-2" value="{{ $d->fisico_mecanica_folio }}" placeholder="Folio">
                        <input type="date" name="fisico_mecanica_expedicion" class="form-control mb-2" value="{{ $d->fisico_mecanica_expedicion }}">
                        <input type="date" name="fisico_mecanica_expiracion" class="form-control mb-2" value="{{ $d->fisico_mecanica_expiracion }}">
                        <input type="file" name="fisico_mecanica_doc" class="form-control mb-3">
                        
                        <select name="status" class="form-select mb-3">
                          @foreach(array_keys($statuses) as $estado)
                            <option {{ $d->status == $estado ? 'selected' : '' }}>{{ $estado }}</option>
                          @endforeach
                        </select>
                      </div>
                    </div>
                    <button type="submit" class="btn btn-primary-custom w-100 mt-2">Guardar Cambios</button>
                  </form>
                </div>
              </div>
            </div>
          </div>
          @endforeach
        </tbody>
      </table>
    </div>

    <div class="pagination-container p-3">
      {{ $dollys->links('pagination::bootstrap-5') }}
    </div>
  </div>
</div>

<!-- ➕ Nuevo Dolly Modal -->
<div class="modal fade" id="newDollyModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Nuevo Dolly</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="newDollyForm" enctype="multipart/form-data">
          @csrf
          <div class="row">
            <div class="col-md-6">
              <input type="text" name="unidad" class="form-control mb-2" placeholder="Unidad" required>
              <input type="text" name="marca" class="form-control mb-2" placeholder="Marca">
              <input type="number" name="anio" class="form-control mb-2" placeholder="Año">
              <input type="text" name="placa" class="form-control mb-2" placeholder="Placa">
              <input type="text" name="niv" class="form-control mb-2" placeholder="Número de Serie (NIV)">
              <input type="text" name="color" class="form-control mb-2" placeholder="Color">
            </div>
            <div class="col-md-6">
              <h6 class="mt-2">🔧 Físico Mecánica</h6>
              <input type="text" name="fisico_mecanica_folio" class="form-control mb-2" placeholder="Folio">
              <input type="date" name="fisico_mecanica_expedicion" class="form-control mb-2">
              <input type="date" name="fisico_mecanica_expiracion" class="form-control mb-2">
              <input type="file" name="fisico_mecanica_doc" class="form-control mb-3">
              <select name="status" class="form-select mb-3">
                @foreach(array_keys($statuses) as $estado)
                  <option>{{ $estado }}</option>
                @endforeach
              </select>
            </div>
          </div>
          <button type="submit" class="btn btn-primary-custom w-100 mt-2">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script>
document.addEventListener('DOMContentLoaded', ()=>{
  const csrf=document.querySelector('meta[name="csrf-token"]').content;
  const rows=document.querySelectorAll('#dollysTable tbody tr');
  const fUnidad=document.getElementById('filterUnidad');
  const fPlaca=document.getElementById('filterPlaca');
  const fStatus=document.getElementById('filterStatus');

  function filter(){
    const u=fUnidad.value.toLowerCase();
    const p=fPlaca.value.toLowerCase();
    const s=fStatus.value;
    rows.forEach(r=>{
      const unidad=r.cells[1].innerText.toLowerCase();
      const placa=r.cells[4].innerText.toLowerCase();
      const st=r.cells[5].innerText.trim();
      const show=(!u||unidad.includes(u))&&(!p||placa.includes(p))&&(!s||st===s);
      r.style.display=show?'':'none';
    });
  }
  [fUnidad,fPlaca,fStatus].forEach(el=>{
    el.addEventListener('input',filter);
    el.addEventListener('change',filter);
  });

  // Create
  document.getElementById('newDollyForm').addEventListener('submit',async e=>{
    e.preventDefault();
    const res=await fetch('{{ route('dollys.store') }}',{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'Accept':'application/json'},body:new FormData(e.target)});
    const d=await res.json();
    if(d.success){alert('Dolly agregado exitosamente');location.reload();}
  });

  // Edit
  document.querySelectorAll('.editDollyForm').forEach(f=>{
    f.addEventListener('submit',async e=>{
      e.preventDefault();
      const id=f.dataset.id;
      const res=await fetch(`/dollys/${id}`,{method:'POST',headers:{'X-CSRF-TOKEN':csrf,'X-HTTP-Method-Override':'PUT','Accept':'application/json'},body:new FormData(f)});
      const d=await res.json();
      if(d.success){alert('Dolly actualizado');location.reload();}
    });
  });
});
</script>
</body>

@endsection
