<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{
    DashboardController,
    CargaController,
    TractorController,
    ConductorController,
    UsuarioController,
    RemolqueController,
    DollyController,
    AuthController
};
use App\Http\Controllers\ClientController;

Route::resource('clients', ClientController::class);


Route::resource('remolques', RemolqueController::class);
Route::resource('dollys', DollyController::class);
Route::post('/tractores/{id}/assign', [TractorController::class, 'assign'])->name('tractores.assign');


Route::middleware(['auth'])->group(function () {
    Route::get('/usuarios/profile', [UsuarioController::class, 'profile'])->name('usuarios.profile');
    Route::post('/usuarios/profile/update', [UsuarioController::class, 'updateProfile'])->name('usuarios.updateProfile');
    Route::post('/usuarios/profile/password', [UsuarioController::class, 'updatePassword'])->name('usuarios.updatePassword');
});

// 🔐 Login
Route::get('/', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post');

// 🔒 Protected Routes
Route::middleware('auth')->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Modules
    Route::get('/cargas', [CargaController::class, 'index'])->name('cargas.index');
    Route::get('/tractores', [TractorController::class, 'index'])->name('tractores.index');
    Route::get('/conductores', [ConductorController::class, 'index'])->name('conductores.index');
    


Route::prefix('usuarios')->group(function () {
    Route::get('/', [UsuarioController::class, 'index'])->name('usuarios.index');
    Route::post('/', [UsuarioController::class, 'store'])->name('usuarios.store');
    Route::put('/{id}', [UsuarioController::class, 'update'])->name('usuarios.update');
});

    
    
    


Route::post('/tractores', [TractorController::class, 'store'])->name('tractores.store');
Route::put('/tractores/{id}', [TractorController::class, 'update'])->name('tractores.update');

    
    

Route::get('/conductores', [ConductorController::class, 'index'])->name('conductores.index');
Route::post('/conductores', [ConductorController::class, 'store'])->name('conductores.store');
Route::put('/conductores/{id}', [ConductorController::class, 'update'])->name('conductores.update');


    // Logout
    Route::get('/logout', [AuthController::class, 'logout'])->name('logout');
});
